package de.davidartmann.rosa.db.async;

import android.content.Context;
import android.os.AsyncTask;

import de.davidartmann.rosa.db.PersonDao;
import de.davidartmann.rosa.model.Person;

/**
 * AsyncTask to update a Person in the DB.
 * Created by david on 04.03.16.
 */
public class UpdatePersonInDb extends AsyncTask<Person, Integer, Person> {

    private Context context;
    private PersonDao personDao;
    private IUpdatePersonInDb iUpdatePersonInDb;

    public UpdatePersonInDb(Context context, IUpdatePersonInDb iUpdatePersonInDb) {
        this.context = context;
        this.iUpdatePersonInDb = iUpdatePersonInDb;
    }

    @Override
    protected Person doInBackground(Person... persons) {
        personDao = new PersonDao(context);
        personDao.openWritable();
        return personDao.update(persons[0]);
    }

    @Override
    protected void onPostExecute(Person person) {
        super.onPostExecute(person);
        iUpdatePersonInDb.onUpdate(person);
        personDao.close();
    }

    public interface IUpdatePersonInDb {
        void onUpdate(Person person);
    }
}
